/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringDecomposer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.CreditButton;
import snownee.jade.gui.ItemButton;
import snownee.jade.gui.PluginsConfigScreen;
import snownee.jade.gui.ProfileConfigScreen;
import snownee.jade.gui.WailaConfigScreen;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.SmoothChasingValue;

public class HomeConfigScreen
extends Screen {
    private final RandomSource random = RandomSource.create((long)42L);
    private final Screen parent;
    private final SmoothChasingValue titleY;
    private final List<TextParticle> particles = Lists.newArrayList();
    private final List<TextParticle> pendingParticles = Lists.newArrayList();
    private final List<TextParticle> persistentParticles = Lists.newArrayList();
    private float ticks;
    private byte festival;
    private float nextParticleIn;
    private boolean showTranslators;
    private int lastMouseX;
    private int lastMouseY;

    public HomeConfigScreen(Screen parent) {
        super((Component)Component.translatable((String)"gui.jade.configuration"));
        this.parent = parent;
        this.titleY = new SmoothChasingValue().start(8.0f).target(32.0f).withSpeed(0.1f);
        LocalDate now = LocalDate.now();
        int month = now.getMonthValue();
        int day = now.getDayOfMonth();
        if (month == 12 && day >= 24 && day <= 26) {
            this.festival = 1;
        } else if (month == 6 && (day == 1 || day == 28)) {
            this.festival = (byte)2;
        } else if (month <= 2 && HomeConfigScreen.isLunarNewYear(now)) {
            this.festival = (byte)99;
        }
    }

    private static boolean isLunarNewYear(LocalDate now) {
        int newYearMonthAndDay;
        int year = now.getYear();
        switch (year) {
            case 2026: {
                int n = 217;
                break;
            }
            case 2027: {
                int n = 206;
                break;
            }
            case 2028: {
                int n = 126;
                break;
            }
            case 2029: {
                int n = 213;
                break;
            }
            case 2030: {
                int n = 203;
                break;
            }
            case 2031: {
                int n = 123;
                break;
            }
            case 2032: {
                int n = 211;
                break;
            }
            case 2033: {
                int n = 131;
                break;
            }
            case 2034: {
                int n = 219;
                break;
            }
            case 2035: {
                int n = 208;
                break;
            }
            case 2036: {
                int n = 128;
                break;
            }
            case 2037: {
                int n = 215;
                break;
            }
            case 2038: {
                int n = 204;
                break;
            }
            case 2039: {
                int n = 124;
                break;
            }
            case 2040: {
                int n = 212;
                break;
            }
            case 2041: {
                int n = 201;
                break;
            }
            case 2042: {
                int n = 122;
                break;
            }
            case 2043: {
                int n = 210;
                break;
            }
            default: {
                int n = newYearMonthAndDay = 0;
            }
        }
        if (newYearMonthAndDay == 0) {
            return false;
        }
        int newYearMonth = newYearMonthAndDay / 100;
        int newYearDay = newYearMonthAndDay % 100;
        LocalDate newYearDate = LocalDate.of(year, newYearMonth, newYearDay);
        int newYearDayOfYear = newYearDate.getDayOfYear();
        int dayOfYear = now.getDayOfYear();
        return dayOfYear >= newYearDayOfYear - 1 && dayOfYear <= newYearDayOfYear + 2;
    }

    protected void init() {
        Objects.requireNonNull(this.minecraft);
        this.particles.clear();
        MutableComponent modSettings = Component.translatable((String)"gui.jade.jade_settings");
        MutableComponent pluginSettings = Component.translatable((String)"gui.jade.plugin_settings");
        MutableComponent profileSettings = Component.translatable((String)"gui.jade.profile_settings");
        int maxWidth = Math.max(100, Math.max(this.font.width((FormattedText)modSettings) + 8, this.font.width((FormattedText)pluginSettings) + 8));
        maxWidth = Math.min(maxWidth, Math.min(240, this.width / 2 - 40));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)modSettings, w -> {
            this.visitedChildScreen();
            this.minecraft.setScreen((Screen)new WailaConfigScreen(this));
        }).bounds(this.width / 2 - 5 - maxWidth, this.height / 2 - 10, maxWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)pluginSettings, w -> {
            this.visitedChildScreen();
            this.minecraft.setScreen((Screen)new PluginsConfigScreen(this));
        }).bounds(this.width / 2 + 5, this.height / 2 - 10, maxWidth, 20).build());
        ItemButton profileButton = new ItemButton(this.width / 2 + 10 + maxWidth, this.height / 2 - 10, 20, 20, new ItemStack((ItemLike)Items.PAPER, 2), (Component)profileSettings, w -> {
            this.visitedChildScreen();
            this.minecraft.setScreen((Screen)new ProfileConfigScreen(this));
        }, Button.DEFAULT_NARRATION);
        profileButton.setTooltip(Tooltip.create((Component)profileSettings));
        this.addRenderableWidget((GuiEventListener)profileButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, w -> this.onClose()).bounds(this.width / 2 - 50, this.height / 2 + 20, 100, 20).build());
        Style style = Style.EMPTY;
        if (this.festival != 0 && this.festival != 1) {
            style = style.withColor(15852452);
        }
        MutableComponent title = Component.translatable((String)"gui.jade.by", (Object[])new Object[]{Component.literal((String)"\u2764").withStyle(ChatFormatting.RED)}).withStyle(style);
        MutableComponent hoveredTitle = Component.translatable((String)"gui.jade.by.hovered").withStyle(style);
        int btnWidth = this.font.width((FormattedText)title);
        int btnX = (int)((float)this.width * 0.5f - (float)btnWidth * 0.5f);
        int btnY = (int)((float)this.height * 0.9f - 5.0f);
        MutableComponent narration = Component.translatable((String)(this.festival == 99 ? "narration.jade.by.lunar" : "narration.jade.by"));
        CreditButton creditButton = (CreditButton)this.addRenderableWidget((GuiEventListener)new CreditButton(btnX, btnY, btnWidth, 10, (Component)title, (Component)hoveredTitle, b -> ConfirmLinkScreen.confirmLinkNow((Screen)this, (String)"https://www.curseforge.com/members/snownee_/projects"), this::triggerAuthorButton, arg_0 -> HomeConfigScreen.lambda$init$5((Component)narration, arg_0)));
        if (this.showTranslators) {
            creditButton.showTranslators();
        }
    }

    private void visitedChildScreen() {
        this.titleY.set(this.titleY.getTarget());
        this.showTranslators = true;
    }

    private void triggerAuthorButton(Button button) {
        if (this.festival == 2 || this.festival == 3) {
            this.festival = (byte)3;
            return;
        }
        IntArrayList colors = new IntArrayList();
        String text = "\u2744";
        if (this.festival == 99) {
            for (i = 0; i < 11; ++i) {
                colors.add(this.random.nextBoolean() ? 0xA80000 : 12589056);
            }
            text = "\u2710";
        } else {
            for (i = 0; i < 11; ++i) {
                colors.add(ARGB.colorFromFloat((float)1.0f, (float)(1.0f - this.random.nextFloat() * 0.6f), (float)1.0f, (float)1.0f));
            }
        }
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            int color = (Integer)intListIterator.next();
            int ox = this.random.nextIntBetweenInclusive(-button.getWidth() / 2, button.getWidth() / 2);
            float x = (float)this.width * 0.5f + (float)ox;
            float y = this.random.nextIntBetweenInclusive(button.getY(), button.getY() + button.getHeight());
            float dx = (float)ox * 0.08f;
            float dy = -5.0f - this.random.nextFloat() * 3.0f;
            TextParticle particle = new TextParticle(text, x, y, dx, dy, color, 0.75f + this.random.nextFloat() * 0.5f);
            this.particles.add(particle);
            if (this.festival != 99) continue;
            particle.age = 8.0f + this.random.nextFloat() * 5.0f;
        }
    }

    public void onClose() {
        IWailaConfig.get().save();
        WailaClientRegistration.instance().reloadIgnoreLists();
        Objects.requireNonNull(this.minecraft).setScreen(this.parent);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float scaledY;
        float scaledX;
        Objects.requireNonNull(this.minecraft);
        float deltaTicks = Minecraft.getInstance().getDeltaTracker().getRealtimeDeltaTicks();
        this.ticks += deltaTicks;
        if (this.ticks > this.nextParticleIn) {
            if (this.festival == 3) {
                this.nextParticleIn = this.ticks;
                if (this.pendingParticles.isEmpty()) {
                    this.festival3populateNew();
                }
                if (Mth.abs((int)(mouseX - this.lastMouseX)) >= 3 || Mth.abs((int)(mouseY - this.lastMouseY)) >= 3) {
                    this.lastMouseX = mouseX;
                    this.lastMouseY = mouseY;
                    TextParticle particle = this.pendingParticles.removeFirst();
                    particle.x = mouseX;
                    particle.y = mouseY;
                    particle.gravity = 0.0f;
                    particle.age = 40.0f;
                    this.particles.add(particle);
                    this.persistentParticles.add(particle);
                    if (this.persistentParticles.size() > 50) {
                        TextParticle first = this.persistentParticles.removeFirst();
                        first.persistent = false;
                    }
                }
            } else if (this.festival == 1) {
                this.nextParticleIn = this.ticks + 10.0f + this.random.nextFloat() * 10.0f;
                int color = ARGB.colorFromFloat((float)1.0f, (float)(1.0f - this.random.nextFloat() * 0.6f), (float)1.0f, (float)1.0f);
                int x = this.random.nextIntBetweenInclusive(40, this.width + 100);
                TextParticle particle = new TextParticle("\u2744", x, -20.0f, -0.3f, 0.5f, color |= this.random.nextInt(80) + 40 << 24, 2.0f + this.random.nextFloat());
                particle.gravity = 0.0f;
                this.particles.add(particle);
            }
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
        boolean smallUI = this.minecraft.getWindow().getGuiScale() < 3;
        int left = this.width / 2 - 105;
        int top = this.height / 4 - 20;
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)left, (float)top);
        float scale = smallUI ? 2.0f : 1.5f;
        graphics.pose().scale(scale);
        graphics.drawString(this.font, ModIdentification.getModFullName("jade").orElse("Jade"), 0, 0, -1);
        graphics.pose().scale(0.5f);
        this.titleY.tick(deltaTicks);
        String desc2 = I18n.get((String)"gui.jade.configuration.desc2", (Object[])new Object[0]);
        if (desc2.isEmpty()) {
            graphics.pose().popMatrix();
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)left, (float)top);
            scaledX = mouseX - left;
            scaledY = mouseY - top;
        } else {
            scaledX = (float)(mouseX - left) / scale * 2.0f;
            scaledY = (float)(mouseY - top) / scale * 2.0f;
        }
        this.drawFancyTitle(graphics, I18n.get((String)"gui.jade.configuration.desc1", (Object[])new Object[0]), Math.min(this.titleY.value, 20.0f), 20.0f, scaledX, scaledY);
        if (!desc2.isEmpty()) {
            this.drawFancyTitle(graphics, desc2, Math.min(this.titleY.value + 3.0f, 32.0f), 32.0f, scaledX, scaledY);
        }
        graphics.pose().popMatrix();
        this.particles.removeIf(p -> {
            p.tick(deltaTicks);
            if (p.y > (float)(this.height + 20)) {
                return true;
            }
            p.render(graphics, this.font, mouseX, mouseY);
            return false;
        });
    }

    private void festival3populateNew() {
        IntArrayList colors = new IntArrayList();
        String text = this.random.nextBoolean() ? "UwU" : "OwO";
        switch (this.random.nextInt(7)) {
            case 0: {
                colors.add(14942979);
                colors.add(16747520);
                colors.add(16772352);
                colors.add(32806);
                colors.add(7547266);
                colors.add(7547266);
                break;
            }
            case 1: {
                colors.add(6016762);
                colors.add(16099768);
                colors.add(0xFFFFFF);
                colors.add(16099768);
                colors.add(6016762);
                break;
            }
            case 2: {
                colors.add(14025328);
                colors.add(14025328);
                colors.add(10178454);
                colors.add(14504);
                colors.add(14504);
                break;
            }
            case 3: {
                colors.add(16720268);
                colors.add(16720268);
                colors.add(16766976);
                colors.add(16766976);
                colors.add(2208255);
                colors.add(2208255);
                break;
            }
            case 4: {
                colors.add(0);
                colors.add(0xA3A3A3);
                colors.add(0xFFFFFF);
                colors.add(0x800080);
                break;
            }
            case 5: {
                colors.add(16742052);
                colors.add(0xFFFFFF);
                colors.add(12587479);
                colors.add(0);
                colors.add(3095742);
                break;
            }
            case 6: {
                colors.add(16577588);
                colors.add(0xFFFFFF);
                colors.add(10246609);
                colors.add(0x2C2C2C);
            }
        }
        IntListIterator intListIterator = colors.iterator();
        while (intListIterator.hasNext()) {
            int color = (Integer)intListIterator.next();
            for (int i = 0; i < 5; ++i) {
                float rot = this.random.nextFloat() * ((float)Math.PI * 2);
                float dx = Mth.cos((float)rot) * 2.0f;
                float dy = Mth.sin((float)rot) * 2.0f;
                TextParticle particle = new TextParticle(text, 0.0f, 0.0f, dx, dy, color | 0xFF000000, 1.0f);
                this.pendingParticles.add(particle);
            }
        }
    }

    private void drawFancyTitle(GuiGraphics guiGraphics, String text, float y, float expectY, float mouseX, float mouseY) {
        float distY = Math.abs(y - expectY);
        if (distY >= 9.0f) {
            return;
        }
        int color = IWailaConfig.Overlay.applyAlpha(-5592406, 1.0f - distY / 10.0f);
        float glint1 = (this.ticks - y / 5.0f) % 90.0f / 45.0f * (float)this.width;
        float glint2 = mouseX;
        float glint1Strength = 1.0f;
        float glint2Strength = 1.0f - Mth.clamp((float)(Math.abs(mouseY - y) / 20.0f), (float)0.0f, (float)1.0f);
        MutableComponent component = Component.empty();
        MutableInt curX = new MutableInt();
        StringDecomposer.iterateFormatted((String)text, (Style)Style.EMPTY, (index, style, codePoint) -> {
            String s = Character.toString(codePoint);
            int width = this.font.width(s);
            int curXVal = curX.getValue();
            curX.add(width);
            float dist = Math.abs((float)(curXVal += width / 2) - glint1);
            float localGlint1 = 0.65f + Mth.clamp((float)(1.0f - dist / 20.0f), (float)0.0f, (float)1.0f) * 0.35f * glint1Strength;
            dist = Math.abs((float)curXVal - glint2);
            float localGlint2 = 0.65f + Mth.clamp((float)(1.0f - dist / 20.0f), (float)0.0f, (float)1.0f) * 0.35f * glint2Strength;
            float colorMul = Math.max(localGlint1, localGlint2);
            int originalColor = style.getColor() == null ? 0xAAAAAA : style.getColor().getValue();
            component.append((Component)Component.literal((String)s).withStyle(style).withColor(ARGB.scaleRGB((int)originalColor, (float)colorMul)));
            return true;
        });
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(0.0f, y);
        guiGraphics.drawString(this.font, (Component)component, 0, 0, color);
        guiGraphics.pose().popMatrix();
    }

    private static /* synthetic */ MutableComponent lambda$init$5(Component narration, Supplier $) {
        return narration.copy();
    }

    private class TextParticle {
        private float age;
        private String text;
        private float x;
        private float y;
        private float motionX;
        private float motionY;
        private int color;
        private float scale;
        private float gravity = 0.98f;
        private boolean persistent = true;
        private float fade = 1.0f;

        public TextParticle(String text, float x, float y, float motionX, float motionY, int color, float scale) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.motionX = motionX;
            this.motionY = motionY;
            this.color = color;
            this.scale = scale;
        }

        private void tick(float partialTicks) {
            this.x += this.motionX * partialTicks;
            this.y += this.motionY * partialTicks;
            this.motionY += this.gravity * partialTicks;
            if (HomeConfigScreen.this.festival == 3) {
                this.motionX *= 0.88f;
                this.motionY *= 0.88f;
                if (this.age < 0.0f) {
                    this.persistent = false;
                }
            }
            boolean greaterThanZero = this.age > 0.0f;
            this.age -= partialTicks;
            if (HomeConfigScreen.this.festival == 99 && greaterThanZero && this.age <= 0.0f) {
                this.text = HomeConfigScreen.this.random.nextBoolean() ? "\u2734" : "\u2733";
                this.color = HomeConfigScreen.this.random.nextBoolean() ? 16765991 : 15778837;
                Objects.requireNonNull(HomeConfigScreen.this.minecraft);
                HomeConfigScreen.this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)(HomeConfigScreen.this.random.nextBoolean() ? SoundEvents.FIREWORK_ROCKET_BLAST : SoundEvents.FIREWORK_ROCKET_LARGE_BLAST), (float)0.7f));
            }
            if (!this.persistent) {
                this.fade = Math.max(0.0f, this.fade - partialTicks * 0.25f);
            }
        }

        private void render(GuiGraphics graphics, Font font, int mouseX, int mouseY) {
            if (HomeConfigScreen.this.festival == 99 && this.age < -4.0f) {
                return;
            }
            graphics.pose().pushMatrix();
            graphics.pose().translate(this.x, this.y);
            graphics.pose().scale(this.scale);
            int color = this.color;
            if (HomeConfigScreen.this.festival == 1) {
                graphics.pose().rotate(this.age / 50.0f);
                float alpha = Mth.clamp((float)((Math.abs((float)mouseX - this.x) + Math.abs((float)mouseY - this.y)) / 50.0f), (float)0.25f, (float)1.0f);
                color = IWailaConfig.Overlay.applyAlpha(color, alpha);
            } else if (this.fade != 1.0f) {
                color = IWailaConfig.Overlay.applyAlpha(color, this.fade);
            }
            graphics.drawString(font, this.text, 0, 0, color);
            graphics.pose().popMatrix();
        }
    }
}

